/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.util.preferences;

import com.aptana.editor.php.util.Key;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org2.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;

public class XMLPreferencesWriter {
    public static final char DELIMITER = '\u0005';

    public static String getEscaped(String s) {
        StringBuilder result = new StringBuilder(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XMLPreferencesWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static void appendEscapedChar(StringBuilder buffer, char c) {
        String replacement = XMLPreferencesWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    private static void write(StringBuilder sb, Map map) {
        Set keys = map.keySet();
        for (String key : keys) {
            sb.append("<");
            sb.append(key);
            sb.append(">");
            Object object = map.get(key);
            if (object instanceof Map) {
                XMLPreferencesWriter.write(sb, (Map)object);
            } else if (object != null) {
                sb.append(XMLPreferencesWriter.getEscaped(object.toString()));
            } else {
                sb.append("");
            }
            sb.append("</");
            sb.append(key);
            sb.append(">");
        }
    }

    public static void write(Key prefsKey, IXMLPreferencesStorable[] objects, ProjectScope projectScope, IWorkingCopyManager workingCopyManager) {
        StringBuilder sb = new StringBuilder();
        XMLPreferencesWriter.appendDelimitedString(sb, objects);
        prefsKey.setStoredValue((IScopeContext)projectScope, sb.toString(), workingCopyManager);
    }

    public static void write(IPreferenceStore store, String prefsKey, IXMLPreferencesStorable object) {
        StringBuilder sb = new StringBuilder();
        XMLPreferencesWriter.write(sb, object.storeToMap());
        store.setValue(prefsKey, sb.toString());
    }

    public static void write(IPreferenceStore store, String prefsKey, IXMLPreferencesStorable[] objects) {
        StringBuilder sb = new StringBuilder();
        XMLPreferencesWriter.appendDelimitedString(sb, objects);
        store.setValue(prefsKey, sb.toString());
    }

    public static void write(Preferences pluginPreferences, String prefsKey, IXMLPreferencesStorable[] objects) {
        StringBuilder sb = new StringBuilder();
        XMLPreferencesWriter.appendDelimitedString(sb, objects);
        pluginPreferences.setValue(prefsKey, sb.toString());
    }

    public static void write(Preferences pluginPreferences, String prefsKey, IXMLPreferencesStorable object) {
        StringBuilder sb = new StringBuilder();
        XMLPreferencesWriter.write(sb, object.storeToMap());
        pluginPreferences.setValue(prefsKey, sb.toString());
    }

    private static void appendDelimitedString(StringBuilder buffer, IXMLPreferencesStorable[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                XMLPreferencesWriter.write(buffer, elements[i].storeToMap());
                if (i < elements.length - 1) {
                    buffer.append('\u0005');
                }
                ++i;
            }
        }
    }

    public static String storableElementsToString(IXMLPreferencesStorable[] elements) {
        StringBuilder sb = new StringBuilder();
        XMLPreferencesWriter.appendDelimitedString(sb, elements);
        return sb.toString();
    }
}

